precision mediump float;

#define HIGHLIGHT_BOTTOM_COLOUR       vec3(0.3,0.9,0.9)
#define HIGHLIGHT_TOP_COLOUR          vec3(0.2,0.2,0.2)
#define HIGHLIGHT_COLOR_MIX           0.30
#define HIGHLIGHT_LUMINANCE_POWER     0.6

uniform sampler2D texture_normal;

varying vec2 v_uv;

void main()
{
    vec4 normal  = texture2D( texture_normal, v_uv);
   
    vec4  ssnormal = (normal*2.0)-1.0;
    float nl_bottom = dot(ssnormal.xyz,vec3(0.0, 1.0,0.0));
    float nl_top    = dot(ssnormal.xyz,vec3(0.0,-1.0,0.0));
    vec3 attr = (HIGHLIGHT_BOTTOM_COLOUR * clamp(nl_bottom,0.0,1.0)) + (HIGHLIGHT_TOP_COLOUR * clamp(nl_top,0.0,1.0));    
    float lum = dot(attr,vec3(0.30, 0.59, 0.11))*HIGHLIGHT_LUMINANCE_POWER;
       
    // Write to normal buffers    
    gl_FragColor = vec4(normal.xyz,lum);    
}
